<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Person extends Model 
{

    protected $table = 'persons';
    public $timestamps = true;

    public function company()
    {
        return $this->belongsTo('App\Models\Company', 'company_id');
    }

    public function comments()
    {
        return $this->morphMany('App\Models\Comment');
    }

    public function communications()
    {
        return $this->hasMany('App\Models\Communication', 'person_id');
    }

}